close all;

figure
plot(T,MAX,'LineWidth',2);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('J=f(x,y)','FontSize',18,'FontWeight','bold');
title('Output','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
axis([0 150 0.1 1.05]);
saveas(gcf,'unicycle_output.eps','psc2');


figure
plot(X,Y,'LineWidth',2);
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
title('Vehicle Trajectory','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%axis tight
saveas(gcf,'unicycle_trajectory.eps','psc2');


figure
plot(T,Vx,'LineWidth',2);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('V','FontSize',18,'FontWeight','bold');
title('Control Input of Surge Velocity before Modulation','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
saveas(gcf,'unicycle_v.eps','psc2');

figure
plot(T,wo/50*ones(size(T)),'LineWidth',2);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('\omega_0','FontSize',18,'FontWeight','bold');
title('Control Input of Angula Velocity','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
saveas(gcf,'unicycle_wo.eps','psc2');
